<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Like;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Post\PostLikeTable;

final class PostLikeFinder extends AbstractFinder implements InterfacePostLikeSetter
{
    /**
     * setter interface
     */
    use TraitPostLikeSetters;

    public function getTableName(): string
    {
        return PostLikeTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {PostLikeTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): PostLikeModel
    {
        return PostLikeModel::createFromUntouchedBean_noException(parent::pop());
    }
}
